<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_stock_products', function (Blueprint $table) {
            $table->id();
            $table->string('stock_erp', 100)->nullable();
            $table->string('stock_system', 100)->nullable();
            $table->date('registration_date');
            $table->date('last_update');
            $table->bigInteger('idproduct')->unsigned();
            $table->bigInteger('idwarehouse')->nullable()->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1);
            $table->timestamps();

            $table->foreign('idproduct')->references('id')->on('tbl_products');
            $table->foreign('idwarehouse')->references('id')->on('tbl_store');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_stock_products');
    }
};
