<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_customer_wallet', function (Blueprint $table) {
            $table->id();
            $table->string('description');
            $table->bigInteger('idsupplier')->unsigned();
            $table->bigInteger('idsalesman')->unsigned();
            $table->bigInteger('idaccount_status')->unsigned();
            $table->date('relationship_date');
            $table->date('last_purchase');
            $table->string('goal');
            $table->bigInteger('idbranchoffice')->unsigned()->nullable();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idsupplier')->references('id')->on('tbl_supplier');
            $table->foreign('idsalesman')->references('id')->on('tbl_salesman');
            $table->foreign('idaccount_status')->references('id')->on('tbl_account_status');
            $table->foreign('idbranchoffice')->references('id')->on('tbl_branch_office');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_customer_wallet');
    }
};
