<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_supplier_contact', function (Blueprint $table) {
            $table->id();
            $table->string('rut', 15);
            $table->string('name', 100);
            $table->string('position', 100);
            $table->string('email', 100)->nullable();
            $table->string('phone', 15)->nullable();
            $table->bigInteger('idsupplier')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');

            $table->foreign('idsupplier')->references('id')->on('tbl_supplier');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_supplier_contact');
    }
};
