<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_products_import', function (Blueprint $table) {
            $table->id();
            $table->string('code', 100)->nullable();
            $table->text('barcode', 100)->nullable();
            $table->string('name', 100)->nullable();
            $table->text('description')->nullable();
            $table->float('cost', 20, 3)->default(0);
            $table->float('price', 20, 3)->default(0);
            $table->float('alternativeprice', 20, 3)->nullable();
            $table->float('margin', 20, 3)->nullable();
            $table->float('offerprice', 20, 3)->nullable();
            $table->integer('stock')->default(0);
            $table->integer('minimumstock')->default(0);
            $table->integer('maximumstock')->default(0);

            $table->text('main_image')->nullable()->comment('imagen principal');
            $table->text('optional_image1')->nullable()->comment('imagen opcional');
            $table->text('optional_image2')->nullable()->comment('imagen opcional');
            $table->text('optional_image3')->nullable()->comment('imagen opcional');
            $table->text('optional_image4')->nullable()->comment('imagen opcional');

            $table->text('idattributes')->nullable()->comment('[]');
            $table->text('idspecificattributes')->nullable()->comment('[]');
            $table->text('iduses')->nullable()->comment('[]');
            $table->text('idspecificuses')->nullable()->comment('[]');
            $table->bigInteger('idcointype')->unsigned()->nullable();
            $table->bigInteger('idcategory')->unsigned()->nullable();
            $table->bigInteger('idsubcategory')->unsigned()->nullable();
            $table->bigInteger('idspecificsubcategory')->unsigned()->nullable();
            $table->bigInteger('idtype')->unsigned()->nullable();
            $table->bigInteger('idsupplier')->unsigned()->nullable();
            $table->bigInteger('idunitmeasure')->unsigned()->nullable();
            $table->bigInteger('idunitmeasureoptional')->unsigned()->nullable();
            $table->bigInteger('idbusinessarea')->unsigned()->nullable();
            $table->bigInteger('idclassification')->unsigned()->nullable();
            $table->text('idwarehouses')->nullable()->comment('[]');
            $table->bigInteger('idcompany')->unsigned();
            $table->bigInteger('created_by')->unsigned();
            $table->char('status_import', 1)->default(0)->comment('0: Sin importar, 1:Importado, 2:Eliminado');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idcointype')->references('id')->on('tbl_coin_type');
            $table->foreign('idcategory')->references('id')->on('tbl_categories');
            $table->foreign('idsubcategory')->references('id')->on('tbl_sub_categories');
            $table->foreign('idspecificsubcategory')->references('id')->on('tbl_specific_sub_categories');
            $table->foreign('idtype')->references('id')->on('tbl_types_products');
            $table->foreign('idsupplier')->references('id')->on('tbl_supplier');
            $table->foreign('idunitmeasure')->references('id')->on('tbl_unit_measure');
            $table->foreign('idunitmeasureoptional')->references('id')->on('tbl_unit_measure');
            $table->foreign('idbusinessarea')->references('id')->on('tbl_business_area');
            $table->foreign('idclassification')->references('id')->on('tbl_product_classification');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->foreign('created_by')->references('id')->on('tbl_user');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_products_import');
    }
};
