<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_store', function (Blueprint $table) {
            $table->id();
            $table->string('code', 25)->nullable();
            $table->integer('iderp')->nullable();
            $table->string('name', 100);
            $table->text('description')->nullable();
            $table->string('address', 100)->nullable();
            $table->bigInteger('idbranchoffice')->nullable()->unsigned();
            $table->bigInteger('iddistrict')->nullable()->unsigned();
            $table->bigInteger('idprovince')->nullable()->unsigned();
            $table->bigInteger('iddepartment')->nullable()->unsigned();
            $table->bigInteger('idcountry')->nullable()->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idbranchoffice')->references('id')->on('tbl_branch_office');
            $table->foreign('iddistrict')->references('id')->on('tbl_district');
            $table->foreign('idcountry')->references('id')->on('tbl_country');
            $table->foreign('idprovince')->references('id')->on('tbl_province');
            $table->foreign('iddepartment')->references('id')->on('tbl_department');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_store');
    }
};
