<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_products', function (Blueprint $table) {
            $table->id();
            $table->string('code_erp', 100)->nullable();
            $table->string('code_system', 100)->nullable();
            $table->text('barcode', 100)->nullable();
            $table->text('name', 100);
            $table->text('description')->nullable();
            $table->float('cost', 20, 3)->nullable();
            $table->float('price', 20, 3)->nullable();
            $table->float('alternativeprice', 20, 3)->nullable();
            $table->float('margin', 20, 3)->nullable();
            $table->float('offerprice', 20, 3)->nullable();
            $table->integer('minimumstock')->nullable();
            $table->integer('maximumstock')->nullable();

            $table->text('main_image')->nullable()->comment('imagen principal');
            $table->text('optional_image1')->nullable()->comment('imagen opcional');
            $table->text('optional_image2')->nullable()->comment('imagen opcional');
            $table->text('optional_image3')->nullable()->comment('imagen opcional');
            $table->text('optional_image4')->nullable()->comment('imagen opcional');

            $table->text('idattributes')->nullable()->comment('[]');
            $table->text('idspecificattributes')->nullable()->comment('[]');
            $table->text('iduses')->nullable()->comment('[]');
            $table->text('idspecificuses')->nullable()->comment('[]');
            $table->bigInteger('idcointype')->unsigned()->nullable();
            $table->bigInteger('idcategory')->nullable()->unsigned();
            $table->bigInteger('idsubcategory')->nullable()->unsigned();
            $table->bigInteger('idspecificsubcategory')->nullable()->unsigned();
            $table->bigInteger('idtype')->nullable()->unsigned();
            // $table->bigInteger('idsupplier')->unsigned();
            $table->bigInteger('idsupplier')->nullable()->unsigned();
            $table->bigInteger('idunitmeasure')->nullable()->unsigned();
            $table->bigInteger('idunitmeasureoptional')->nullable()->unsigned();
            $table->bigInteger('idbusinessarea')->nullable()->unsigned();
            $table->bigInteger('idclassification')->nullable()->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idcointype')->references('id')->on('tbl_coin_type');
            $table->foreign('idcategory')->references('id')->on('tbl_categories');
            $table->foreign('idsubcategory')->references('id')->on('tbl_sub_categories');
            $table->foreign('idspecificsubcategory')->references('id')->on('tbl_specific_sub_categories');
            $table->foreign('idtype')->references('id')->on('tbl_types_products');
            $table->foreign('idsupplier')->references('id')->on('tbl_supplier');
            $table->foreign('idunitmeasure')->references('id')->on('tbl_unit_measure');
            $table->foreign('idunitmeasureoptional')->references('id')->on('tbl_unit_measure');
            $table->foreign('idbusinessarea')->references('id')->on('tbl_business_area');
            $table->foreign('idclassification')->references('id')->on('tbl_product_classification');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_products');
    }
};
