<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_business_area', function (Blueprint $table) {
            $table->id();
            $table->integer('iderp')->nullable();
            $table->string('name', 45);
            $table->text('description')->nullable();
            $table->bigInteger('idbranchoffice')->unsigned()->nullable();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idbranchoffice')->references('id')->on('tbl_branch_office');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_business_area');
    }
};
