<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_branch_office', function (Blueprint $table) {
            $table->id();
            $table->integer('iderp')->nullable();
            $table->string('code', 100);
            $table->string('name', 100);
            $table->string('phone',15)->nullable();
            $table->string('address', 100);
            $table->char('assignmenttype', 1)->comment('1 = sucursal, 2 = usuario');
            $table->bigInteger('idproductlist')->nullable()->unsigned();
            $table->bigInteger('idofficetype')->unsigned();
            $table->bigInteger('iddistrict')->unsigned()->nullable();
            $table->bigInteger('idprovince')->unsigned()->nullable();
            $table->bigInteger('iddepartment')->unsigned()->nullable();
            $table->bigInteger('idcountry')->unsigned()->nullable();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idproductlist')->references('id')->on('tbl_list_of_products');
            $table->foreign('idofficetype')->references('id')->on('tbl_branch_office_type');
            $table->foreign('iddistrict')->references('id')->on('tbl_district');
            $table->foreign('idcountry')->references('id')->on('tbl_country');
            $table->foreign('idprovince')->references('id')->on('tbl_province');
            $table->foreign('iddepartment')->references('id')->on('tbl_department');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_branch_office');
    }
};
