<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_relation_product_attribute', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('parent_attribute_id')->unsigned();
            $table->bigInteger('child_attribute_id')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('parent_attribute_id')->references('id')->on('tbl_product_attributes');
            $table->foreign('child_attribute_id')->references('id')->on('tbl_product_attributes');
            $table->foreign('idcompany')->references('id')->on('tbl_company');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_relation_product_attribute');
    }
};
