<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_product_attributes', function (Blueprint $table) {
            $table->id();
            $table->string('code', 25);
            $table->string('name', 100);
            $table->text('description')->nullable();
            $table->bigInteger('idtype')->unsigned();
            $table->bigInteger('idreference')->unsigned()->nullable();
            $table->text('idspecificattributes')->nullable()->comment('[]');
            $table->bigInteger('createdby')->nullable()->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idtype')->references('id')->on('tbl_type_attribute');
            $table->foreign('createdby')->references('id')->on('tbl_user');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_product_attributes');
    }
};
