<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_relation_type_attribute', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('parent_type')->unsigned();
            $table->bigInteger('child_type')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();
            
            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->foreign('parent_type')->references('id')->on('tbl_type_attribute');
            $table->foreign('child_type')->references('id')->on('tbl_type_attribute');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_relation_type_attribute');
    }
};
