<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_way_to_pay_for_company', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('idway_to_pay')->unsigned();
            $table->text('idtools')->nullable()->comment('[]');
            $table->char('cuotas', 1)->default(0);
            $table->text('idcuotas')->nullable()->comment('[]');
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0 = desactivado; 1 = activo; 2 = eliminado');
            $table->timestamps();

            $table->foreign('idway_to_pay')->references('id')->on('tbl_way_to_pay');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_way_to_pay_for_company');
    }
};
