<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_supplier', function (Blueprint $table) {
            $table->id();
            $table->string('rut', 15);
            $table->string('name_rz', 100)->index();
            $table->string('fantasy_name', 100)->nullable()->index();
            $table->string('web', 100)->nullable();
            $table->string('giro', 100);
            $table->string('email', 100);
            $table->string('phone', 100);
            $table->string('fax', 15)->nullable();
            $table->integer('type')->comment('1 = cliente, 2 = proveedor, 3= all');
            $table->char('legal_nature', 2)->comment('33=Persona juridica, 39= Persona natural');

            $table->bigInteger('idwaytopay')->unsigned()->nullable();
            // $table->bigInteger('idsalesman')->unsigned();
            $table->bigInteger('idsegment')->unsigned()->nullable();
            // $table->bigInteger('idprice_list')->unsigned()->nullable();

            $table->bigInteger('idcountry')->unsigned()->nullable();
            $table->bigInteger('iddepartment')->unsigned()->nullable();
            $table->bigInteger('idprovince')->unsigned()->nullable();
            $table->bigInteger('iddistrict')->unsigned()->nullable();
            $table->string('address', 100)->nullable();

            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');

            $table->foreign('idwaytopay')->references('id')->on('tbl_way_to_pay');
            // $table->foreign('idsalesman')->references('id')->on('tbl_salesman');
            $table->foreign('idsegment')->references('id')->on('tbl_segment');
            // $table->foreign('idprice_list')->references('id')->on('tbl_price_list');

            $table->foreign('idcountry')->references('id')->on('tbl_country');
            $table->foreign('iddepartment')->references('id')->on('tbl_department');
            $table->foreign('idprovince')->references('id')->on('tbl_province');
            $table->foreign('iddistrict')->references('id')->on('tbl_district');

            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_supplier');
    }
};
