<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_document_of_sale_for_company', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('iddocument_of_sale')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('iddocument_of_sale')->references('id')->on('tbl_document_of_sale');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_document_of_sale');
    }
};
