<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_way_to_pay', function (Blueprint $table) {
            $table->id();
            $table->integer('iderp')->nullable();
            $table->string('name');
            $table->char('agenda', 1)->default(0);
            $table->integer('days')->nullable();
            $table->integer('SII_fmapago')->default(0)->comment('1: Contado, 2: Crédito');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_way_to_pay');
    }
};
