<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_salesman', function (Blueprint $table) {
            $table->id();
            $table->string('rut', 15);
            $table->string('name', 100);
            $table->string('surname', 100);
            $table->string('gender', 1)->comment('0 = masculino, 1 = femenino');
            $table->integer('type_person')->comment('0 = natural, 1 = juridica');
            $table->integer('age')->unsigned();
            $table->date('birthdate');
            $table->string('email', 100);
            $table->string('address', 200)->nullable();
            $table->string('phone', 15)->nullable();
            $table->bigInteger('idchannel')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');

            $table->foreign('idchannel')->references('id')->on('tbl_sale_channel');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_salesman');
    }
};
