<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_price_list', function (Blueprint $table) {
            $table->id();
            $table->string('code', 25);
            $table->string('name', 100);
            $table->text('description')->nullable();
            $table->date('creation_date');
            $table->date('validity_date')->nullable();
            $table->char('document_state', 1)->default(0)->comment('0 = desactivado, 1 = activado');
            $table->integer('quantity_products');
            $table->integer('total')->nullable();
            $table->char('type', 1)->default(1)->comment('1=general, 2=sucursal, 3=salesman, 4=segment, 5=customer');
            $table->char('discounttype', 1)->default(2)->comment('1=$, 2=%, 3=sin descuento');
            $table->float('max_desc_item', 20, 3)->default(0)->nullable();
            $table->float('max_desc_global', 20, 3)->default(0)->nullable();

            $table->bigInteger('created_by')->unsigned();
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('created_by')->references('id')->on('tbl_user');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_price_list');
    }
};
