<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_detail_user_company', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('iduser')->unsigned();
            $table->bigInteger('iduser_type')->unsigned();
            $table->bigInteger('idprivilege')->unsigned();
            $table->bigInteger('idcompany')->unsigned();          
            $table->char('status_confirm', 1)->default(0)->comment('0 = sin confirmar; 1 = confirmado');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('iduser')->references('id')->on('tbl_user');
            $table->foreign('iduser_type')->references('id')->on('tbl_user_type');
            $table->foreign('idprivilege')->references('id')->on('tbl_privilege');
            $table->foreign('idcompany')->references('id')->on('tbl_company');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_detail_user_company');
    }
};
