<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_user', function (Blueprint $table) {
            $table->id();
            $table->string('rut', 15);
            $table->string('email', 100);
            $table->string('phone', 15)->nullable();
            $table->string('username', 100);
            $table->text('password');
            $table->text('encrypted_password');
            $table->bigInteger('idcompany')->unsigned();
            $table->char('status_confirm', 1)->default(0)->comment('0 = sin confirmar; 1 = confirmado');
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');

            $table->foreign('idcompany')->references('id')->on('tbl_company');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_user');
    }
};
