<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_company', function (Blueprint $table) {
            $table->id();
            $table->string('rut', 15)->unique();
            $table->string('business_name', 100);
            $table->string('address');
            $table->string('email', 100);
            $table->string('phone', 25);
            $table->string('giro', 100)->nullable();
            $table->bigInteger('iddistrict')->unsigned()->nullable();
            $table->string('code_comerce_wp')->nullable()->comment('Código de comercio');
            $table->string('api_key_wp')->nullable()->comment('Key comercio');
            $table->bigInteger('idmembership')->unsigned()->nullable();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');

            $table->foreign('iddistrict')->references('id')->on('tbl_district');
            $table->foreign('idmembership')->references('id')->on('tbl_membership');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_company');
    }
};
