<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_membership', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('key')->nullable()->comment('Llave del archivo plans.php');
            $table->char('view_pay', 1)->nullable();
            $table->text('url_redirect')->nullable();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_membership');
    }
};
