<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_province', function (Blueprint $table) {
            $table->id();
            $table->string('code', 10);
            $table->string('name', 45);
            $table->bigInteger('iddepartment')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('iddepartment')->references('id')->on('tbl_department');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_province');
    }
};
