<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_department', function (Blueprint $table) {
            $table->id();
            $table->string('code', 10);
            $table->string('name', 45);
            $table->bigInteger('idcountry')->unsigned();
            $table->bigInteger('idtimezone')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idcountry')->references('id')->on('tbl_country');
            $table->foreign('idtimezone')->references('id')->on('tbl_country_time_zone');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_department');
    }
};
