<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_country', function (Blueprint $table) {
            $table->id();
            $table->string('code', 10);
            $table->string('abbreviation',3);
            $table->string('name', 45);
            $table->string('nationality', 45);
            $table->string('language', 45);
            $table->string('coin', 45);
            $table->string('subdivision_coin', 45)->nullable();
            $table->string('coin_code', 45);
            $table->bigInteger('idtimezone')->unsigned();
            $table->char('status', 1)->default(1)->comment('0: Inactivo, 1:Activo, 2:Eliminado');
            $table->timestamps();

            $table->foreign('idtimezone')->references('id')->on('tbl_country_time_zone');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_country');
    }
};
