<?php

namespace App\Services;

use App\Traits\HasResponse;
use App\Models\User;
use App\Models\UserERP;
use Illuminate\Support\Facades\Crypt;


class UserErpService
{
    use HasResponse;
    protected $softnetService;

    public function __construct(SoftnetService $softnetService)
    {
        $this->softnetService = $softnetService;
    }

    public function verify($iduser, $params) {

        $userErp = UserERP::where('iduser', $iduser)->where('status', 1)->first();
        if(!$userErp) return $this->errorResponse('Usuario erp no encontrado', 400);
        return $this->successResponse('OK', $userErp);

    }

    public function register($params){
        $userErpFind = UserERP::where('iduser', $params['iduser'])->where('status', 1)->first();
        if($userErpFind) return $this->errorResponse('Usuario erp ya se encuentra registrado', 400);

        #Probar sesion con ERP
        $token = $this->softnetService->getLoginSoftnet((object) $params);
        if(!$token) return $this->errorResponse('Credenciales incorrectas');
        $params['token'] = $token;
        $params['encrypted_password'] = Crypt::encryptString($params['password']);
        $params['password'] = bcrypt($params['password']);
        $userErp = UserERP::create($params);
        return $this->successResponse('OK', $userErp);
    }

    public function update($id, $params){
        
        $userErpFind = UserERP::where('id', $id)->where('status', 1)->first();
        if(!$userErpFind) return $this->errorResponse('Usuario erp no se encuentra registrado', 400);

        #Probar sesion con ERP
        $token = $this->softnetService->getLoginSoftnet((object) $params);
        if(!$token) return $this->errorResponse('Credenciales incorrectas');
        $params['token'] = $token;
        $params['encrypted_password'] = Crypt::encryptString($params['password']);
        $params['password'] = bcrypt($params['password']);
        $userErpFind->update($request);
        return $this->successResponse('Usuario ERP actualizado correctamente', $userErpFind);

    }

    public function delete($id){

        $userErpFind = UserERP::where('id', $id)->where('status', 1)->first();
        if(!$userErpFind) return $this->errorResponse('Usuario erp no se encuentra registrado', 400);

        $userErpFind->update(['status' => 2]);
        return $this->successResponse('Usuario ERP eliminado correctamente', $userErpFind);

    } 

}