<?php

namespace App\Services;

use App\Models\Country;
use App\Models\Department;
use App\Models\District;
use App\Models\Province;
use App\Traits\HasResponse;

class UbigeoService
{
    use HasResponse;

    public function listCountries($params, $withPagination)
    {
        $countries = Country::where('status', 1)->orderBy('id', 'desc');

        $search = isset($params['search']) ? $params['search'] : '';
        if($search){
            $countries->where(function ($query) use ($search) {
                $query->where('name', 'like', "%$search%");
            });
        }

        $countries = !empty($withPagination)
            ? $countries->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $countries->get();

        return $this->successResponse('Lectura exitosa.', $countries);
    }

    public function listDepartments($params, $withPagination)
    {
        $departments = Department::where('status', 1)->orderBy('id', 'desc');

        $idcountry = isset($params['idcountry']) ? $params['idcountry'] : '';
        if($idcountry) {
            $departments->where(function ($query) use ($idcountry) {
                $query->where('idcountry', $idcountry);
            });
        }

        $search = isset($params['search']) ? $params['search'] : '';
        if($search){
            $departments->where(function ($query) use ($search) {
                $query->where('name', 'like', "%$search%");
            });
        }

        $departments = !empty($withPagination)
            ? $departments->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $departments->get();

        return $this->successResponse('Lectura exitosa.', $departments);
    }

    public function listProvinces($params, $withPagination)
    {
        $provinces = Province::where('status', 1)->orderBy('id', 'desc');

        $iddepartment = isset($params['iddepartment']) ? $params['iddepartment'] : '';
        if($iddepartment) {
            $provinces->where(function ($query) use ($iddepartment) {
                $query->where('iddepartment', $iddepartment);
            });
        }

        $search = isset($params['search']) ? $params['search'] : '';
        if($search){
            $provinces->where(function ($query) use ($search) {
                $query->where('name', 'like', "%$search%");
            });
        }

        $provinces = !empty($withPagination)
            ? $provinces->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $provinces->get();

        return $this->successResponse('Lectura exitosa.', $provinces);
    }

    public function listDistricts($params, $withPagination)
    {
        $districs = District::where('status', 1)->orderBy('id', 'desc');

        $idprovince = isset($params['idprovince']) ? $params['idprovince'] : '';
        if($idprovince) {
            $districs->where(function ($query) use ($idprovince) {
                $query->where('idprovince', $idprovince);
            });
        }

        $search = isset($params['search']) ? $params['search'] : '';
        if($search){
            $districs->where(function ($query) use ($search) {
                $query->where('name', 'like', "%$search%");
            });
        }

        $districs = !empty($withPagination)
            ? $districs->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $districs->get();

        return $this->successResponse('Lectura exitosa.', $districs);
    }
}
