<?php

namespace App\Services;

use App\Http\Resources\TypeSaleResource;
use App\Models\TypeSale;
use App\Traits\HasResponse;
use Illuminate\Support\Facades\DB;

/**
 * Class TypeSaleService
 * @package App\Services
 */
class TypeSaleService
{
    use HasResponse;

    public function list($params, $withPagination)
    {
        $typesSale = TypeSale::typeSaleFilters()->orderBy('id', 'desc');
        
        $typesSale = !empty($withPagination)
            ? $typesSale->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $typesSale->get();

        $typesSale = TypeSaleResource::collection($typesSale->load('company'));

        return $this->successResponse('Lectura exitosa.', $typesSale);
    }

    public function register($params)
    {
        DB::beginTransaction();
        try {
            #Validar duplicidad de nombres
            $type = TypeSale::where('name', $params['name'])->active()->company()->first();
            if ($type) return $this->errorResponse('El nombre ingresado ya se encuentra registrado.', 400);

            $type = TypeSale::create([
                'name' => $params['name'],
                'idcompany' => $params['idcompany']
            ]);

            DB::commit();
            return $this->successResponse('Tipo de venta creado con éxito', $type);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->externalError('durante la creación de un tipo de venta.', $th->getMessage());
        }
    }

    public function update($id, $params)
    {
        DB::beginTransaction();
        try {
            #Validar tipo de venta
            $type = TypeSale::activeForID($id)->first();
            if ($type) return $this->errorResponse('Tipo de venta no válido.', 400);

            #Validar duplicidad de nombres
            $type = TypeSale::where('id', '!=', $id)->where('name', $params['name'])->active()->company()->first();
            if ($type) return $this->errorResponse('El nombre ingresado ya se encuentra registrado.', 400);

            $type = TypeSale::find($id);
            $type->update($params);

            DB::commit();
            return $this->successResponse('Tipo de venta actualizado con éxito', $type);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->externalError('durante la actualización de un tipo de venta.', $th->getMessage());
        }
    }

    public function delete($id)
    {
        DB::beginTransaction();
        try {
            #Validar tipo de venta
            $type = TypeSale::activeForID($id)->first();
            if ($type) return $this->errorResponse('Tipo de venta no válido.', 400);

            $type = TypeSale::find($id);
            $type->update(['status' => 2]);

            DB::commit();
            return $this->successResponse('Tipo de venta eliminado con éxito', $type);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->externalError('durante la eliminación de un tipo de venta.', $th->getMessage());
        }
    }
}
