<?php

namespace App\Services;

use App\Models\Permissions;
use App\Traits\HasResponse;

class PermissionsService
{

    use HasResponse;

    public function list($params, $withPagination)
    {
        $details = Permissions::permissionsFilters() # Filtrado por el modelo
            ->orderBy('id', 'asc');

        $details = !empty($withPagination)
            ? $details->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $details->get();

        $details = $details;

        return $this->successResponse('Lectura exitosa.', $details);
    }
}
