<?php

namespace App\Services;

use App\Http\Resources\MembershipResource;
use App\Models\Membership;
use App\Models\MembershipPlans;
use App\Traits\HasResponse;
use Illuminate\Support\Facades\DB;

class MembershipService
{
    use HasResponse;

    public function getMembership($params, $withPagination)
    {
        $membership = Membership::active();

        if (isset($params['view_pay'])) $membership = $membership->where('view_pay', $params['view_pay']);

        $membership = !empty($withPagination)
            ? $membership->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $membership->get();

        return $this->successResponse('Lectura exitosa.', MembershipResource::collection($membership));
    }

    public function getPlans()
    {
        return $this->successResponse('Lectura exitosa.', MembershipPlans::all());
    }

    public function getMembershipProfessional($withPagination)
    {
        $membership = Membership::whereIn('id', [1, 2, 3])->active();

        $membership = !empty($withPagination)
            ? $membership->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $membership->get();

        return $this->successResponse('Lectura exitosa.', MembershipResource::collection($membership));
    }

    public function createMembership($params)
    {
        DB::beginTransaction();
        try {
            $membership = Membership::create([
                'name'          => $params['name'],
                'view_pay'      => $params['view_pay'],
                'url_redirect'  => $params['url_redirect']
            ]);
            $membership->fresh();
            DB::commit();
            return $this->successResponse('Membresía creada con éxito.', $membership);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->externalError('durante la creación de una membresía.', $th->getMessage());
        }
    }
}
