<?php

namespace App\Services;

use App\Models\DocumentOfSale;
use App\Models\DocumentOfSaleForCompany;
use App\Traits\HasResponse;

class DocumentOfSalesService
{
    use HasResponse;

    public function list($params, $withPagination)
    {
        $documentOfSales = DocumentOfSale::where('status', 1)->orderBy('id', 'desc');

        $search = isset($params['search']) ? $params['search'] : '';
        if($search){
            $documentOfSales->where(function ($query) use ($search) {
                $query->where('name', 'like', "%$search%");
            });
        }

        $documentOfSales = !empty($withPagination)
            ? $documentOfSales->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $documentOfSales->get();

        return $this->successResponse('Lectura exitosa.', $documentOfSales);
    }

    public function listByCompany($params, $withPagination)
    {
        $details = DocumentOfSaleForCompany::where('status', 1)->orderBy('id', 'desc');

        $idcompany = isset($params['idcompany']) ? $params['idcompany'] : '';
        if($idcompany) {
            $details->where(function ($query) use ($idcompany) {
                $query->where('idcompany', $idcompany);
            });
        }

        $details =  $details->pluck('iddocument_of_sale')->unique()->values()->all();

        $documentOfSales = DocumentOfSale::where('status', 1)->whereIn('id', $details)->orderBy('id', 'desc');

        $search = isset($params['search']) ? $params['search'] : '';
        if($search){
            $documentOfSales->where(function ($query) use ($search) {
                $query->where('name', 'like', "%$search%");
            });
        }

        $documentOfSales = !empty($withPagination)
            ? $documentOfSales->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $documentOfSales->get();

        return $this->successResponse('Lectura exitosa.', $documentOfSales);
    }

}
