<?php

namespace App\Services;

use App\Http\Resources\ClientAddressResource;
use App\Models\Company;
use App\Models\Country;
use App\Models\Department;
use App\Models\District;
use App\Models\PriceList;
use App\Models\Province;
use App\Models\Salesman;
use App\Models\Segment;
use App\Models\ClientAddress;
use App\Models\WayToPay;
use App\Traits\HasResponse;
use Illuminate\Support\Facades\DB;

/**
 * Class ClientAddressService
 * @package App\Services
 */
class ClientAddressService
{
    use HasResponse;

    public function list($params, $withPagination)
    {
        $clientAddresss = ClientAddress::filters()->orderBy('id', 'desc');

        $clientAddresss = !empty($withPagination)
            ? $clientAddresss->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $clientAddresss->get();

        $clientAddresss = ClientAddressResource::collection($clientAddresss->load('country', 'department', 'province', 'district', 'company'));

        return $this->successResponse('Lectura exitosa.', $clientAddresss);
    }

    public function register($params)
    {
        DB::beginTransaction();
        try {
            #Validar duplicidad de address
            $address = ClientAddress::where('address', $params['address'])->active()->first();
            if ($address) return $this->errorResponse('Ya existe un registro con la dirección ingresada.', 400);
            
            $clientAddress = ClientAddress::create();
            $clientAddress->save();

            DB::commit();
            return $this->successResponse('Dirección registrada satisfactoriamente.', $clientAddress);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->externalError('durante la creación de dirección.', $th->getMessage());
        }
    }

    public function update($id, $params)
    {
        DB::beginTransaction();
        try {
            #Validar dirección
            $clientAddress = ClientAddress::activeForId($id)->first();
            if (!$clientAddress) return $this->errorResponse('Dirección no válido.', 400);

            #Validar duplicidad de dirección
            $address = ClientAddress::where('id', '!=', $id)->where('address', $params['address'])->active()->first();
            if ($address) return $this->errorResponse('Ya existe un registro con la dirección ingresado.', 400);
            
            $clientAddress->update($params);
            $clientAddress->save();

            DB::commit();
            return $this->successResponse('Dirección actualizado satisfactoriamente.', $clientAddress);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->externalError('durante la edición de un dirección.', $th->getMessage());
        }
    }

    public function delete($id)
    {
        try {
            #Validar dirección
            $clientAddress = ClientAddress::activeForId($id)->first();
            if (!$clientAddress) return $this->errorResponse('Dirección no válido.', 400);

            $clientAddress->status = 2;
            $clientAddress->save();

            DB::commit();
            return $this->successResponse('Dirección actualizado satisfactoriamente.', $clientAddress);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->externalError('durante la edición de un dirección.', $th->getMessage());
        }
    }
}
