<?php

namespace App\Services;

use App\Http\Resources\BankResource;
use App\Models\Bank;
use App\Traits\HasResponse;

class BankService
{
    use HasResponse;

    public function list($withPagination)
    {
        $bank = Bank::bankFilters()->orderBy('id', 'desc');

        $bank = !empty($withPagination)
            ? $bank->paginate($withPagination['perPage'], page: $withPagination['page'])
            : $bank->get();

        return $this->successResponse('Lectura exitosa.', BankResource::collection($bank->load('country')));
    }
}
