<?php

namespace App\Observers;

use App\Models\DetailUserCompany;
use App\Models\Salesman;
use App\Models\User;
use App\Traits\HasResponse;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class SalesmanObserver
{
    use HasResponse;

    protected static $username;

    public static function setUsername($username)
    {
        static::$username = $username;
    }

    # Al crear
    public function created(Salesman $salesman): void
    {
        
    }

    # Al actualizar
    public function updated(Salesman $salesman): void
    {
        DB::beginTransaction();
        try {
            $user = User::rut($salesman->rut, 3)->first();
            
            # En caso de actualizar el estado del supervisor a un 2 se realiza lo mismo para el usuario relacionado
            if ($salesman->status == 2 || $salesman->status == 0) {
                $detailUser = DetailUserCompany::where('iduser', $user->id)->where('iduser_type', 3)->active()->first();
                if ($detailUser) $detailUser->update(['status' => 2]);
            }

            #Al actualizar el rut actualizar el usuario
            $user->update(['rut' => $salesman->rut]);
            
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
        }
    }
}
