<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Model;

class WayToPayForCompany extends Model
{
    use HasFactory;

    protected $table = "tbl_way_to_pay_for_company";
    protected $primaryKey = "id";

    protected $fillable = [
        'idway_to_pay',
        'idtools',
        'cuotas',
        'idcuotas',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    #Relaciones
    public function wayToPay(): HasOne
    {
        return $this->hasOne(WayToPay::class, 'id', 'idway_to_pay');
    }
    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    # Filtros
    public function scopeUserFilters($query)
    {
        #Filtro de forma de pago
        $query->when(
            request('idway_to_pay'),
            fn ($query) => $query->where('idway_to_pay', request('idway_to_pay'))
        );

        #Filtro de herramientas
        $query->when(
            request('idtools'),
            fn ($query) => $query->where('idtools', request('idtools'))
        );

        #Filtro de cuotas
        $query->when(
            request('idcuotas'),
            fn ($query) => $query->where('idcuotas', request('idcuotas'))
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );
    }

}
