<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = "tbl_user";

    protected $fillable = [
        'rut',
        'email',
        'phone',
        'username',
        'password',
        'idcompany',
        'encrypted_password',
        'status_confirm',
        'status'
    ];

    protected $hidden = [
        'password',
        'encrypted_password',
        'created_at',
        'updated_at'
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }

    #Relaciones
    public function detailUser(): HasMany
    {
        return $this->hasMany(DetailUserCompany::class, 'iduser', 'id');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeRut($query, $rut, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('rut', $rut);
    }

    public function scopeEmail($query, $email, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('email', $email);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    # Filtros
    public function scopeUserFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('rut', 'LIKE', '%' . request('search') . '%')
                ->orWhere('username', 'LIKE', '%' . request('search') . '%')
        );

        #Filtro de RUT
        $query->when(
            request('rut'),
            fn ($query) => $query->where('rut', 'LIKE', '%' . request('rut') . '%')
        );

        #Filtro de nombre de usuario
        $query->when(
            request('username'),
            fn ($query) => $query->where('username', 'LIKE', '%' . request('username') . '%')
        );

        #Filtro de email
        $query->when(
            request('email'),
            fn ($query) => $query->where('email', 'LIKE', '%' . request('email') . '%')
        );

        #Filtro de estado de confirmación
        $query->when(
            request('status_confirm'),
            fn ($query) => $query->where('status_confirm', 'LIKE', '%' . request('status_confirm') . '%')
        );

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );

    }
}
