<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TypeProduct extends Model
{
    use HasFactory;
    protected $table = "tbl_types_products";
    protected $primaryKey = "id";

    protected $fillable = [
        'code',
        'name',
        'description',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCode($query, $code, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('code', $code);
    }

    # Filtros
    public function scopeTypeProductFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('code', 'LIKE', '%' . request('search') . '%')
                ->orWhere('name', 'LIKE', '%' . request('search') . '%')
        );

        #Filtro de codigo
        $query->when(
            request('code'),
            fn ($query) => $query->where('code', 'LIKE', '%' . request('code') . '%')
        );

        #Filtro de nombre
        $query->when(
            request('name'),
            fn ($query) => $query->where('name', 'LIKE', '%' . request('name') . '%')
        );

        #Filtro de descripcion
        $query->when(
            request('description'),
            fn ($query) => $query->where('description', 'LIKE', '%' . request('description') . '%')
        );

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
