<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TimeZone extends Model
{
    use HasFactory;
    protected $table = 'tbl_country_time_zone';

    protected $fillable = [
        'description',
        'time_zone',
        'status'
    ];

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeTimeZone($query, $time_zone, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('time_zone', $time_zone);
    }

    # Filtros
    public function scopeTimeZoneFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('time_zone', 'LIKE', '%' . request('search') . '%')
        );

        #Filtro de timezone
        $query->when(
            request('time_zone'),
            fn ($query) => $query->where('time_zone', 'LIKE', '%' . request('time_zone') . '%')
        );

        #Filtro de descripcion
        $query->when(
            request('description'),
            fn ($query) => $query->where('description', 'LIKE', '%' . request('description') . '%')
        );

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
