<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Supplier extends Model
{
    use HasFactory;
    protected $table = "tbl_supplier";
    protected $primaryKey = "id";

    protected $fillable = [
        'rut',
        'name_rz',
        'fantasy_name',
        'web',
        'giro',
        'email',
        'phone',
        'fax',
        'type',
        'legal_nature',
        'idwaytopay',
        // 'idsalesman',
        'idsegment',
        // 'idprice_list',
        'idcountry',
        'iddepartment',
        'idprovince',
        'iddistrict',
        'address',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function wayToPay(): HasOne
    {
        return $this->hasOne(WayToPay::class, 'id', 'idwaytopay');
    }

    public function salesman(): HasOne
    {
        return $this->hasOne(Salesman::class, 'id', 'idsalesman');
    }

    public function segment(): HasOne
    {
        return $this->hasOne(Segment::class, 'id', 'idsegment');
    }

    public function priceList(): HasOne
    {
        return $this->hasOne(PriceList::class, 'id', 'idprice_list');
    }

    public function country(): HasOne
    {
        return $this->hasOne(Country::class, 'id', 'idcountry');
    }

    public function department(): HasOne
    {
        return $this->hasOne(Department::class, 'id', 'iddepartment');
    }

    public function province(): HasOne
    {
        return $this->hasOne(Province::class, 'id', 'idprovince');
    }

    public function district(): HasOne
    {
        return $this->hasOne(District::class, 'id', 'iddistrict');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeRut($query, $rut, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('rut', $rut)->company();
    }

    # Filtros
    public function scopeSupplierFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('rut', 'LIKE', '%' . request('search') . '%')
                ->orWhere('name_rz', 'LIKE', '%' . request('search') . '%')
                ->orWhere('fantasy_name', 'LIKE', '%' . request('search') . '%')
        );

        #Filtro de rut
        $query->when(
            request('rut'),
            fn ($query) => $query->where('rut', 'LIKE', '%' . request('rut') . '%')
        );

        #Filtro de razon social
        $query->when(
            request('name_rz'),
            fn ($query) => $query->where('name_rz', 'LIKE', '%' . request('name_rz') . '%')
        );

        #Filtro de nombre de fantasia
        $query->when(
            request('fantasy_name'),
            fn ($query) => $query->where('fantasy_name', 'LIKE', '%' . request('fantasy_name') . '%')
        );

        #Filtro de web
        $query->when(
            request('web'),
            fn ($query) => $query->where('web', 'LIKE', '%' . request('web') . '%')
        );

        #Filtro de giro
        $query->when(
            request('giro'),
            fn ($query) => $query->where('giro', 'LIKE', '%' . request('giro') . '%')
        );

        #Filtro de email
        $query->when(
            request('email'),
            fn ($query) => $query->where('email', 'LIKE', '%' . request('email') . '%')
        );

        #Filtro de telefono
        $query->when(
            request('phone'),
            fn ($query) => $query->where('phone', 'LIKE', '%' . request('phone') . '%')
        );

        #Filtro de fax
        $query->when(
            request('fax'),
            fn ($query) => $query->where('fax', 'LIKE', '%' . request('fax') . '%')
        );

        #Filtro de tipo
        $query->when(
            request('type'),
            fn ($query) => $query->where('type', 'LIKE', '%' . request('type') . '%')
        );

        #Filtro de forma de pago
        $query->when(
            request('idwaytopay'),
            fn ($query) => $query->where('idwaytopay', request('idwaytopay'))
        );

        #Filtro de vendedor
        $query->when(
            request('idsalesman'),
            fn ($query) => $query->where('idsalesman', request('idsalesman'))
        );

        #Filtro de vendedor
        $query->when(
            request('idsegment'),
            fn ($query) => $query->where('idsegment', request('idsegment'))
        );

        #Filtro de lista de precios
        $query->when(
            request('idprice_list'),
            fn ($query) => $query->where('idprice_list', request('idprice_list'))
        );

        #Filtro de lista de país
        $query->when(
            request('idcountry'),
            fn ($query) => $query->where('idcountry', request('idcountry'))
        );

        #Filtro de departamento
        $query->when(
            request('iddepartment'),
            fn ($query) => $query->where('iddepartment', request('iddepartment'))
        );

        #Filtro de provincia
        $query->when(
            request('idprovince'),
            fn ($query) => $query->where('idprovince', request('idprovince'))
        );

        #Filtro de distrito
        $query->when(
            request('iddistrict'),
            fn ($query) => $query->where('iddistrict', request('iddistrict'))
        );

        #Filtro de dirección
        $query->when(
            request('address'),
            fn ($query) => $query->where('address', 'LIKE', '%' . request('address') . '%')
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );

    }
}
