<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Store extends Model
{
    use HasFactory;

    protected $table = "tbl_store";
    protected $primaryKey = "id";

    protected $fillable = [
        'code',
        'iderp',
        'name',
        'description',
        'address',
        'idbranchoffice',
        'iddistrict',
        'idprovince',
        'iddepartment',
        'idcountry',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function branchOffice(): HasOne
    {
        return $this->hasOne(BranchOffice::class, 'id', 'idbranchoffice');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    public function district(): HasOne
    {
        return $this->hasOne(District::class, 'id', 'iddistrict');
    }

    public function province(): HasOne
    {
        return $this->hasOne(Province::class, 'id', 'idprovince');
    }

    public function department(): HasOne
    {
        return $this->hasOne(Department::class, 'id', 'iddepartment');
    }

    public function country(): HasOne
    {
        return $this->hasOne(Country::class, 'id', 'idcountry');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeCode($query, $code, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('code', $code);
    }

    # Filtros
    public function scopeStoreFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('code', 'LIKE', '%' . request('search') . '%')
                ->orWhere('name', 'LIKE', '%' . request('search') . '%')
        );

        #Filtro de codigo
        $query->when(
            request('code'),
            fn ($query) => $query->where('code', 'LIKE', '%' . request('code') . '%')
        );

        #Filtro de id de ERP
        $query->when(
            request('iderp'),
            fn ($query) => $query->where('iderp', 'LIKE', '%' . request('iderp') . '%')
        );

        #Filtro de nombre
        $query->when(
            request('name'),
            fn ($query) => $query->where('name', 'LIKE', '%' . request('name') . '%')
        );

        #Filtro de descripcion
        $query->when(
            request('description'),
            fn ($query) => $query->where('description', 'LIKE', '%' . request('description') . '%')
        );

        #Filtro de direccion
        $query->when(
            request('address'),
            fn ($query) => $query->where('address', 'LIKE', '%' . request('address') . '%')
        );

        #Filtro de sucursal
        $query->when(
            request('idbranchoffice'),
            fn ($query) => $query->where('idbranchoffice', request('idbranchoffice'))
        );

        #Filtro de distrito
        $query->when(
            request('iddistrict'),
            fn ($query) => $query->where('iddistrict', request('iddistrict'))
        );

        #Filtro de provincia
        $query->when(
            request('idprovince'),
            fn ($query) => $query->where('idprovince', request('idprovince'))
        );

        #Filtro de departamento
        $query->when(
            request('iddepartment'),
            fn ($query) => $query->where('iddepartment', request('iddepartment'))
        );

        #Filtro de pais
        $query->when(
            request('idcountry'),
            fn ($query) => $query->where('idcountry', request('idcountry'))
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
