<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class StockProduct extends Model
{
    use HasFactory;
    protected $table = "tbl_stock_products";

    protected $fillable = [
        'stock_erp',
        'stock_system',
        'registration_date',
        'last_update',
        'idproduct',
        'idwarehouse',
        'idcompany',
        'status',
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    # Relaciones
    public function product(): HasOne
    {
        return $this->hasOne(Product::class, 'id', 'idproduct');
    }

    public function warehouse(): HasOne
    {
        return $this->hasOne(Store::class, 'id', 'idwarehouse');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeWarehouseID($query, $product, $warehouse, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('idproduct', $product)->where('idwarehouse', $warehouse)->company();
    }

    # Filtros
    public function scopeStockProductFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->whereHas('product',
                fn ($q) => $q->where('code_erp', 'LIKE', '%' . request('search') . '%')
                    ->orWhere('code_system', 'LIKE', '%' . request('search') . '%')
                    ->orWhere('name', 'LIKE', '%' . request('search') . '%'))
        );

        #Filtro de codigo
        $query->when(
            request('code_system'),
            fn ($query) => $query->whereHas('product',
                fn ($q) => $q->where('code_system', 'LIKE', '%' . request('search') . '%'))
        );

        #Filtro de codigo ERP
        $query->when(
            request('code_erp'),
            fn ($query) => $query->whereHas('product',
                fn ($q) => $q->where('code_erp', 'LIKE', '%' . request('search') . '%'))
        );

        #Filtro de fecha de registro
        $query->when(
            request('registration_date'),
            fn ($query) => $query->where('registration_date', request('registration_date'))
        );

        #Filtro de fecha de modificacion
        $query->when(
            request('last_update'),
            fn ($query) => $query->where('last_update', request('last_update'))
        );

        #Filtro de id de producto
        $query->when(
            request('idproduct'),
            fn ($query) => $query->where('idproduct', request('idproduct'))
        );

        #Filtro de id de bodega
        $query->when(
            request('idwarehouse'),
            fn ($query) => $query->where('idwarehouse', request('idwarehouse'))
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
