<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RelationTypeAttribute extends Model
{
    use HasFactory;

    protected $table = "tbl_relation_type_attribute";
    protected $primaryKey = "id";

    protected $fillable = [
        'parent_type',
        'child_type',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    # Relaciones
    public function parentType(): BelongsTo
    {
        return $this->belongsTo(TypeAttribute::class, 'parent_type', 'id');
    }

    public function childType(): BelongsTo
    {
        return $this->belongsTo(TypeAttribute::class, 'child_type', 'id');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    # Filtro de idcompany
    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    # Filtro por parent_type o child_type
    public function scopeByParentOrChildType($query, $typeId)
    {
        return $query->where('parent_type', $typeId)->orWhere('child_type', $typeId);
    }

    # Filtros adicionales
    public function scopeAttributeRelationFilters($query)
    {
        #Filtro de estado
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );

        #Filtro de idcompany
        $query->company();
    }
}
