<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductDetail extends Model
{
    use HasFactory;

    protected $table = "tbl_product_detail";
    protected $primaryKey = "id";

    protected $fillable = [
        'product_id',
        'relation_product_attribute_id',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    #Relaciones
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function relationProductAttribute()
    {
        return $this->belongsTo(RelationProductAttribute::class, 'relation_product_attribute_id');
    }
   

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    # Filtro de idcompany
    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn($query) => $query->where('idcompany', request('idcompany'))
        );
    }

}
