<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class PriceList extends Model
{
    use HasFactory;
    protected $table = 'tbl_price_list';

    protected $fillable = [
        'code',
        'name',
        'description',
        'creation_date',
        'validity_date',
        'document_state',
        'quantity_products',
        'total',
        'type',
        'discounttype',
        'max_desc_item',
        'max_desc_global',
        'created_by',
        'idcompany',
        'status',
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function createdby(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'created_by');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    public function priceListBranchOffice(): HasMany
    {
        return $this->hasMany(DetailPriceListBranchOffice::class, 'idpricelist', 'id')->where('status', 1);
    }

    public function priceListCustomer(): HasMany
    {
        return $this->hasMany(DetailPriceListCustomer::class, 'idpricelist', 'id')->where('status', 1);
    }

    public function priceListProduct(): HasMany
    {
        return $this->hasMany(DetailPriceListProduct::class, 'idpricelist', 'id')->where('status', 1);
    }

    public function priceListSalesman(): HasMany
    {
        return $this->hasMany(DetailPriceListSalesman::class, 'idpricelist', 'id')->where('status', 1);
    }

    public function priceListSegment(): HasMany
    {
        return $this->hasMany(DetailPriceListSegment::class, 'idpricelist', 'id')->where('status', 1);
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeCode($query, $code, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('code', $code)->company();
    }

    public function scopeName($query, $name, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('name', $name)->company();
    }

    # Filtros
    public function scopePricelistFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('code', 'LIKE', '%' . request('search') . '%')
                ->orWhere('name', 'LIKE', '%' . request('search') . '%')
        );

        #Filtro de codigo
        $query->when(
            request('code'),
            fn ($query) => $query->where('code', 'LIKE', '%' . request('code') . '%')
        );

        #Filtro de nombre
        $query->when(
            request('name'),
            fn ($query) => $query->where('name', 'LIKE', '%' . request('name') . '%')
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );

    }
}
