<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class PermissionsUser extends Model
{
    use HasFactory;
    protected $table = 'tbl_permissions_user';

    protected $fillable = [
        'iduser',
        'idcompany',
        'permissions',
        'actions',
        'status'
    ];

    protected $casts = [
        'permissions' => 'array',
        'actions' => 'array'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'iduser');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->where('idcompany', request('idcompany'));
    }

    # Filtros
    public function scopePermissionsUserFilters($query)
    {
        #Filtro de usuario
        $query->when(
            request('iduser'),
            fn ($query) => $query->where('iduser', request('iduser'))
        );

        #Filtro de compañía
        $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );
    }
}
