<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Permissions extends Model
{
    use HasFactory;
    protected $table = 'tbl_permissions';

    public $timestamps = false;

    protected $fillable = [
        'name',
        'route_group',
        'description'
    ];

    protected $casts = [
        'route_group' => 'array'
    ];

    # Filtros
    public function scopePermissionsFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('name', 'LIKE', '%' . request('search') . '%')
        );

    }
}

