<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentCuotas extends Model
{
    use HasFactory;
    protected $table = "tbl_payment_cuotas";
    protected $primaryKey = "id";

    protected $fillable = [
        'numcuotas',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    # Filtros
    public function scopePaymentCuotaFilters($query)
    {
        #Filtro de RUT
        $query->when(
            request('numcuotas'),
            fn ($query) => $query->where('numcuotas', request('numcuotas'))
        );

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );

    }
}
