<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Pay extends Model
{
    use HasFactory;

    protected $table = 'tbl_pay';

    public $timestamps = false;

    protected $fillable = [
        'pay_type',
        'idregister',
        'iduser',
        'amount',
        'purchase_identifier',
        'token',
        'transaction_status',
        'creation_date',
        'status'
    ];

    # Relaciones
    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'iduser');
    }

    # Filtros
    public function scopePayFilters($query)
    {
        # Filtro de usuario
        $query->when(
            request('iduser'),
            fn ($query) => $query->where('iduser', request('iduser'))
        );

        # Filtro de tipo
        $query->when(
            request('pay_type'),
            fn ($query) => $query->where('pay_type', request('pay_type'))
        );

        # Filtro de estado de la operación
        $query->when(
            request('transaction_status'),
            fn ($query) => $query->where('transaction_status', request('transaction_status'))
        );
    }
}
