<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class MembershipCosts extends Model
{
    use HasFactory;

    protected $table = 'tbl_membership_costs';

    public $timestamps = false;

    protected $fillable = [
        'idplans',
        'idmembership',
        'amount',
        'date_start',
        'date_end',
        'UF',
        'cod_erp',
        'status'
    ];

    # Query scope
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    # Relaciones
    public function plans(): HasOne
    {
        return $this->hasOne(MembershipPlans::class, 'id', 'idplans');
    }

    public function membership(): HasOne
    {
        return $this->hasOne(Membership::class, 'id', 'idmembership');
    }
}
