<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Membership extends Model
{
    use HasFactory;

    protected $table = 'tbl_membership';

    public $timestamps = false;

    protected $fillable = [
        'name',
        'key',
        'view_pay',
        'url_redirect',
        'status'
    ];

    # Query scopes
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }
}
