<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class InternalGuideDetail extends Model
{
    use HasFactory;
    protected $table = "tbl_internal_guide_detail";
    protected $fillable = [
        'idinternal_guide',
        'code',
        'idproduct',
        'detail',
        'count',
        'cost',
        'discount_type',
        'discount_amount',
        'discount',
        'total',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    # Relaciones
    public function internalGuide(): HasOne
    {
        return $this->hasOne(InternalGuide::class, 'id', 'idinternal_guide');
    }

    public function product(): HasOne
    {
        return $this->hasOne(Product::class, 'id', 'idproduct');
    }
}
